/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.BookLoadException;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.IngredientData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public class ContentCrafting
extends PageContent {
    public static final class_2960 ID = Mantle.getResource("crafting");
    public static final transient int TEX_SIZE = 256;
    public static final transient ImageData IMG_CRAFTING_LARGE = new ImageData(Textures.TEX_CRAFTING, 0, 0, 183, 114, 256, 256);
    public static final transient ImageData IMG_CRAFTING_SMALL = new ImageData(Textures.TEX_CRAFTING, 0, 114, 155, 78, 256, 256);
    public static final transient int X_RESULT_SMALL = 118;
    public static final transient int Y_RESULT_SMALL = 23;
    public static final transient int X_RESULT_LARGE = 146;
    public static final transient int Y_RESULT_LARGE = 41;
    public static final transient float ITEM_SCALE = 2.0f;
    public static final transient int SLOT_MARGIN = 5;
    public static final transient int SLOT_PADDING = 4;
    public String title = "Crafting";
    public String grid_size = "auto";
    public IngredientData[][] grid;
    public IngredientData result;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        String size;
        int y;
        int x = 0;
        int height = 100;
        int resultX = 100;
        int resultY = 50;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
            y = this.getTitleHeight();
        }
        String string = size = this.grid_size.equalsIgnoreCase("auto") ? "large" : this.grid_size;
        if (size.equalsIgnoreCase("small")) {
            x = 91 - ContentCrafting.IMG_CRAFTING_SMALL.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_SMALL.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_SMALL.width, ContentCrafting.IMG_CRAFTING_SMALL.height, IMG_CRAFTING_SMALL, book.appearance.slotColor));
            resultX = x + 118;
            resultY = y + 23;
        } else if (size.equalsIgnoreCase("large")) {
            x = 91 - ContentCrafting.IMG_CRAFTING_LARGE.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_LARGE.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_LARGE.width, ContentCrafting.IMG_CRAFTING_LARGE.height, IMG_CRAFTING_LARGE, book.appearance.slotColor));
            resultX = x + 146;
            resultY = y + 41;
        }
        if (this.grid != null) {
            for (int i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[i].length; ++j) {
                    if (this.grid[i][j] == null || this.grid[i][j].getItems().isEmpty()) continue;
                    list.add(new ItemElement(x + 5 + (4 + Math.round(32.0f)) * j, y + 5 + (4 + Math.round(32.0f)) * i, 2.0f, (Collection<class_1799>)this.grid[i][j].getItems(), this.grid[i][j].action));
                }
            }
        }
        if (this.result != null) {
            list.add(new ItemElement(resultX, resultY, 2.0f, (Collection<class_1799>)this.result.getItems(), this.result.action));
        }
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, height + 5, 182, 176 - height - 5, this.description));
        }
    }

    @Override
    public void load() {
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && class_2960.method_20207((String)this.recipe)) {
            int w = 0;
            int h = 0;
            assert (class_310.method_1551().field_1687 != null);
            class_1860 recipe = class_310.method_1551().field_1687.method_8433().method_8130(new class_2960(this.recipe)).orElse(null);
            if (recipe instanceof class_3955) {
                if (this.grid_size.equalsIgnoreCase("auto")) {
                    this.grid_size = recipe.method_8113(2, 2) ? "small" : "large";
                }
                switch (this.grid_size.toLowerCase()) {
                    case "large": {
                        h = 3;
                        w = 3;
                        break;
                    }
                    case "small": {
                        h = 2;
                        w = 2;
                    }
                }
                if (!recipe.method_8113(w, h)) {
                    throw new BookLoadException("Recipe " + this.recipe + " cannot fit in a " + w + "x" + h + " crafting grid");
                }
                this.result = IngredientData.getItemStackData(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
                class_2371 ingredients = recipe.method_8117();
                if (recipe instanceof class_1869) {
                    class_1869 shaped = (class_1869)recipe;
                    this.grid = new IngredientData[shaped.method_8158()][shaped.method_8150()];
                    for (int y = 0; y < this.grid.length; ++y) {
                        for (int x = 0; x < this.grid[y].length; ++x) {
                            this.grid[y][x] = IngredientData.getItemStackData((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])((class_1856)ingredients.get(x + y * this.grid[y].length)).method_8105()));
                        }
                    }
                    return;
                }
                this.grid = new IngredientData[h][w];
                for (int i = 0; i < ingredients.size(); ++i) {
                    this.grid[i / h][i % w] = IngredientData.getItemStackData((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])((class_1856)ingredients.get(i)).method_8105()));
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

